<?php
/* --------------------------------------------------------------
 Options.php 2019-10-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read\Collections;

use Gambio\Core\Configuration\Models\Read\Option;

/**
 * Class Options
 * @package Gambio\Core\Configuration\Models\Collections
 */
class Options
{
    /**
     * @var Option[]
     */
    private $options;
    
    
    /**
     * Options constructor.
     *
     * @param Option[] $options
     */
    private function __construct(Option ...$options)
    {
        $this->options = $options;
    }
    
    
    /**
     * Factory method for Options.
     *
     * @param array $options
     *
     * @return Options
     */
    public static function fromArray(array $options): self
    {
        $opts = [];
        foreach ($options as $option) {
            $opts[] = Option::fromArray($option);
        }
        
        return static::create(...$opts);
    }
    
    
    /**
     * Factory method for Options.
     *
     * @param Option[] $options
     *
     * @return Options
     */
    public static function create(Option ...$options): self
    {
        return new static(...$options);
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        $data = [];
        foreach ($this->options as $option) {
            $data[] = $option->toArray();
        }
        
        return $data;
    }
}